<?php
// #############################################################################
if ($_REQUEST['action'] == 'main' OR empty($_REQUEST['action']))
{
	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);

	$welcome = '';
	if (sizeof($vbulletin->options['dbtech_downloads_welcome_message']))
	{
		// Ensure we only do this if needed
		$welcome = $vbulletin->options['dbtech_downloads_welcome_message'];

		if (!function_exists('convert_url_to_bbcode'))
		{
			// Ensure we can convert URL to BBCode
			require_once(DIR . '/includes/functions_newpost.php');
		}
		
		// Convert URL to BBCode
		$welcome = convert_url_to_bbcode($welcome);	

		require_once (DIR . '/includes/class_bbcode.php');
		$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$welcome = $parser->parse($welcome, 'nonforum', true);
	}

	$parentcategories = $childcategories = $tmpchildren = array();
	foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
	{
		if (!$category['parentid'])
		{
			// Only children plz.
			$parentcategories[] = $categoryid;
			continue;
		}

		if (VBDOWNLOADS::$cache['category'][$category['parentid']]['parentid'])
		{
			// Only first children plz.
			//continue;
		}

		if (in_array($categoryid, $_excludeCategories))
		{
			// We can't see this category
			continue;
		}

		if (intval($vbulletin->versionnumber) == 3)
		{
			// Set the comma
			$category['comma'] = ', ';
		}
		else
		{
			// Set the comma
			$category['comma'] = $vbphrase['comma_space'];
		}

		// Set this
		$tmpchildren[$category['parentid']][] = $category;
	}

	foreach ($tmpchildren as $parent => $categories)
	{
		$categories[count($categories) - 1]['comma'] = '';
		foreach ($categories as $category)
		{
			$templater = vB_Template::create('dbtech_downloads_categorybit_subcategorybit');
				$templater->register('category', 	$category);
			$childcategories[$category['parentid']] .= $templater->render();
		}
	}

	if ($vbulletin->GPC['categoryid'] AND (in_array($vbulletin->GPC['categoryid'], $_excludeCategories) OR !isset(VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']])))
	{
		// Skip this
		print_no_permission();
	}

	// Grab our permissions
	$permissions = VBDOWNLOADS::fetchPermissions(NULL, VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']]);

	if (!$vbulletin->GPC['categoryid'])
	{
		// Grab ordered list
		$categoryList = construct_ordered_categories();
	}
	else
	{
		// Grab all child categories
		$categoryList = find_category_children($vbulletin->GPC['categoryid']);
	}

	$categoryInfo = array();
	foreach ($categoryList as $category)
	{
		if (in_array($category['categoryid'], $_excludeCategories))
		{
			// We can't see this category
			continue;
		}

		// Init this list
		$categories = array($category['categoryid'] => $category['title']);

		if (count($category['children']))
		{
			// Construct the list of select options
			construct_category_select_options($categories, $category['children'], 0, false);
		}

		$categoryInfo = $categoryInfo + VBDOWNLOADS::$db->fetchAllKeyed('
			SELECT ? AS categoryid, SUM(totaldownloads) AS downloads, SUM(numfiles) AS files
			FROM $dbtech_downloads_download AS download
			INNER JOIN $dbtech_downloads_category USING(categoryid)
			WHERE categoryid :queryList
				AND download.moderation = 0
			GROUP BY categoryid
		', 'categoryid', array(
			$category['categoryid'],
			':queryList' => VBDOWNLOADS::$db->queryList(array_keys($categories))
		));

		$categoryInfo[$category['categoryid']]['latest'] = VBDOWNLOADS::$db->fetchRow('
			SELECT 
				download.downloadid, 
				download.title, 
				download.updated, 
				download.userid,
				download.private,
				user.*
			FROM $dbtech_downloads_download AS download
			LEFT JOIN $user AS user USING(userid)
			WHERE categoryid :queryList
				AND download.moderation = 0
			ORDER BY updated DESC
			LIMIT 1
		', array(
			$category['categoryid'],
			':queryList' => VBDOWNLOADS::$db->queryList(array_keys($categories))
		));
	}

	$categories = '';
	foreach (VBDOWNLOADS::$cache['category'] as $categoryid => $category)
	{
		if ($vbulletin->GPC['categoryid'] AND $vbulletin->GPC['categoryid'] != $category['parentid'])
		{
			// Skip this
			continue;
		}
		else if (!$vbulletin->GPC['categoryid'] AND $category['parentid'])
		{
			// Only parents plz.
			continue;
		}

		if (in_array($categoryid, $_excludeCategories))
		{
			// We can't see this category
			continue;
		}

		if (!isset($childcategories[$categoryid]))
		{
			// Set children to avoid strict standards errors
			$childcategories[$categoryid] = '';
		}

		if (!isset($categoryInfo[$categoryid]['downloads']))
		{
			// This category has no files, or downloads
			$categoryInfo[$categoryid]['downloads'] = $categoryInfo[$categoryid]['files'] = 0;
		}
		else
		{
			$categoryInfo[$categoryid]['latest']['private'] = @unserialize($categoryInfo[$categoryid]['latest']['private']);
			if (
				!is_array($categoryInfo[$categoryid]['latest']['private']) OR 
				!count($categoryInfo[$categoryid]['latest']['private']) OR 
				(
					in_array($vbulletin->userinfo['userid'], $categoryInfo[$categoryid]['latest']['private']) AND
					$vbulletin->userinfo['userid']
				) OR
				(
					$categoryInfo[$categoryid]['latest']['userid'] == $vbulletin->userinfo['userid'] AND
					$vbulletin->userinfo['userid']
				)
			)
			{
				// Grab musername
				$categoryInfo[$categoryid]['latest']['musername'] = fetch_musername($categoryInfo[$categoryid]['latest']);
				
				// Sort date and time
				$categoryInfo[$categoryid]['latest']['date'] = vbdate($vbulletin->options['dateformat'], $categoryInfo[$categoryid]['latest']['updated'], true);
				$categoryInfo[$categoryid]['latest']['time'] = vbdate($vbulletin->options['timeformat'], $categoryInfo[$categoryid]['latest']['updated']);

				// No hacsors here please
				$categoryInfo[$categoryid]['latest']['title'] = htmlspecialchars_uni($categoryInfo[$categoryid]['latest']['title']);				
			}
		}

		// Sort out these as numbers
		$categoryInfo[$categoryid]['downloads'] = vb_number_format($categoryInfo[$categoryid]['downloads'], 0);
		$categoryInfo[$categoryid]['files'] 	= vb_number_format($categoryInfo[$categoryid]['files'], 	0);		

		$templater = vB_Template::create('dbtech_downloads_categorybit');
			$templater->register('category', 	$category);
			$templater->register('children', 	$childcategories[$categoryid]);
			$templater->register('stats', 		$categoryInfo[$categoryid]);
		$categories .= $templater->render();
	}

	if ($vbulletin->GPC['categoryid'])
	{
		// Get current category info
		$category = VBDOWNLOADS::$cache['category'][$vbulletin->GPC['categoryid']];

		// Store the new navbits
		$navbits2 = array();

		// Add to the navbits
		$navbits2[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $category['categoryid']] = $pagetitle = $category['title'];

		if ($category['parentid'])
		{
			// Store immediate category
			$parentCategory = VBDOWNLOADS::$cache['category'][$category['parentid']];
			
			// Add to the navbits
			$navbits2[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $parentCategory['categoryid']] = $parentCategory['title'];

			do
			{
				// Store immediate category
				$parentCategory = VBDOWNLOADS::$cache['category'][$parentCategory['parentid']];

				// Add to the navbits
				$navbits2[$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . 'categoryid=' . $parentCategory['categoryid']] = $parentCategory['title'];
			}
			while (isset(VBDOWNLOADS::$cache['category'][$parentCategory['parentid']]));

			$navbits2 = array_reverse($navbits2);
			foreach ($navbits2 as $key => $val)
			{
				// Add to the navbits
				$navbits[$key] = $val;
			}
		}

		// Init this
		$fileList = '';

		// Display file list
		do
		{
			if (!$count = VBDOWNLOADS::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_downloads_download
				WHERE categoryid = ?
					AND moderation = 0
			', array(
				$vbulletin->GPC['categoryid']
			)))
			{
				// We need at least one file
				break;
			}

			$vbulletin->input->clean_array_gpc('r', array(
				'pagenumber'  	=> TYPE_UINT,
				'perpage'     	=> TYPE_UINT,
			));

			// Ensure there's no errors or out of bounds with the page variables
			if ($vbulletin->GPC['pagenumber'] < 1)
			{
				$vbulletin->GPC['pagenumber'] = 1;
			}
			$pagenumber = $vbulletin->GPC['pagenumber'];
			$perpage = (!$vbulletin->GPC['perpage'] OR $vbulletin->GPC['perpage'] > 25) ? 25 : $vbulletin->GPC['perpage'];

			// Ensure every result is as it should be
			sanitize_pageresults($count, $pagenumber, $perpage);

			$startat = ($pagenumber - 1) * $perpage;

			// Constructs the page navigation
			$pagenav = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				$vbulletin->options['dbtech_downloads_link'] . '.php?' . $vbulletin->session->vars['sessionurl'] . "do=main",
				"&amp;perpage=$perpage&amp;categoryid=" . $vbulletin->GPC['categoryid']
			);

			if (!$results = VBDOWNLOADS::$db->fetchAll('
				SELECT download.*, user.*
				FROM $dbtech_downloads_download AS download
				LEFT JOIN $user AS user USING(userid)
				WHERE download.categoryid = ?
					AND download.moderation = 0
				ORDER BY download.updated DESC
				LIMIT :limitStart, :limitEnd
			', array(
				':limitStart' => $startat,
				':limitEnd' => $perpage,
				$vbulletin->GPC['categoryid']
			)))
			{
				// We need at least one limiter
				break;
			}

			require_once (DIR . '/includes/class_bbcode.php');
			$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

			$downloads = '';
			foreach ($results as $download)
			{
				// No hacsors here please
				$download['title'] = htmlspecialchars_uni($download['title']);
				
				// Fix date
				$download['date'] = vbdate($vbulletin->options['dateformat'], $download['updated'], true);
				$download['time'] = vbdate($vbulletin->options['timeformat'], $download['updated']);
				
				// Grab markup username
				$download['musername'] = fetch_musername($download);

				if (strlen($download['description']) > $vbulletin->options['dbtech_downloads_previewlength'])
				{
					// Shorten the description
					$download['description'] = substr($download['description'], 0, $vbulletin->options['dbtech_downloads_previewlength']) . '...';
				}

				// Fix description
				$download['description'] = $parser->parse($download['description'], 'nonforum', true, false);

				// Fix numbers
				$download['numfiles'] = vb_number_format($download['numfiles'], 0);
				$download['totaldownloads'] = vb_number_format($download['totaldownloads'], 0);

				// Advanced search
				$templater = vB_Template::create('dbtech_downloads_searchresults_bit');
					$templater->register('download', 	$download);
				$downloads .= $templater->render();
			}

			// Advanced search
			$templater = vB_Template::create('dbtech_downloads_searchresults');
				$templater->register('pagetitle', 	$vbphrase['dbtech_downloads_files']);
				$templater->register('downloads', 	$downloads);
				$templater->register('pagenav', 	$pagenav);
			$fileList .= $templater->render();			
		}
		while (false);
	}
	else
	{
		// Default page title
		$pagetitle = $vbphrase['dbtech_downloads_welcome'];
	}

	$page_templater = vB_Template::create('dbtech_downloads_home');
		$page_templater->register('pagetitle', 		$pagetitle);
		$page_templater->register('welcome', 		$welcome);
		$page_templater->register('categories', 	$categories);
		$page_templater->register('categoryid', 	$vbulletin->GPC['categoryid']);
		$page_templater->register('fileList', 		$fileList);
		$page_templater->register('permissions', 	$permissions);
	$HTML = $page_templater->render();

	/*DBTECH_PRO_START*/
	if ($vbulletin->options['dbtech_downloads_enable_stats'])
	{
		// Grab total downloads
		$show['dbtech_downloads_stats']['downloads'] = vb_number_format(VBDOWNLOADS::$db->fetchOne('
			SELECT COUNT(*) AS count
			FROM $dbtech_downloads_download
		'));

		// Grab total files
		$show['dbtech_downloads_stats']['files'] = vb_number_format(VBDOWNLOADS::$db->fetchOne('
			SELECT COUNT(*) AS count
			FROM $dbtech_downloads_file
		'));

		// Grab disk space usage
		$show['dbtech_downloads_stats']['diskusage'] = vb_number_format(VBDOWNLOADS::$db->fetchOne('
			SELECT SUM(filesize) AS size
			FROM $dbtech_downloads_file
		'), 0, true);

		// Grab bandwidth usage
		$show['dbtech_downloads_stats']['bandwidthusage'] = vb_number_format(VBDOWNLOADS::$db->fetchOne('
			SELECT SUM(filesize) AS size
			FROM $dbtech_downloads_downloadlog
		'), 0, true);		
	}

	if ($vbulletin->options['dbtech_downloads_enable_wol'] AND !$show['search_engine'])
	{
		require_once(DIR . '/includes/functions_bigthree.php');

		$datecut = TIMENOW - $vbulletin->options['cookietimeout'];
		$show['dbtech_downloads_activeusers']['numbervisible'] = 0;
		$show['dbtech_downloads_activeusers']['numberregistered'] = 0;
		$show['dbtech_downloads_activeusers']['numberguest'] = 0;

		$forumusers = $db->query_read_slave("
			SELECT
				user.username, (user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible, user.usergroupid, user.lastvisit,
				session.userid, session.inforum, session.lastactivity, session.badlocation,
				IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid, infractiongroupid
			FROM " . TABLE_PREFIX . "session AS session
			LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
			WHERE session.lastactivity > $datecut
				AND session.location LIKE '%" . $db->escape_string_like($vbulletin->options['dbtech_downloads_link']) . ".php%'
			" . iif($vbulletin->options['displayloggedin'] == 1 OR $vbulletin->options['displayloggedin'] == 3, "ORDER BY username ASC") . "
		");

		if ($vbulletin->userinfo['userid'])
		{
			// fakes the user being online
			$vbulletin->userinfo['joingroupid'] = iif($vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['usergroupid']);
			$userinfos = array
			(
				$vbulletin->userinfo['userid'] => array
				(
					'userid'            =>& $vbulletin->userinfo['userid'],
					'username'          =>& $vbulletin->userinfo['username'],
					'invisible'         =>& $vbulletin->userinfo['invisible'],
					'inforum'           => 0,
					'lastactivity'      => TIMENOW,
					'lastvisit'         =>& $vbulletin->userinfo['lastvisit'],
					'usergroupid'       =>& $vbulletin->userinfo['usergroupid'],
					'displaygroupid'    =>& $vbulletin->userinfo['displaygroupid'],
					'infractiongroupid' =>& $vbulletin->userinfo['infractiongroupid'],
				)
			);
		}
		else
		{
			$userinfos = array();
		}

		while ($loggedin = $db->fetch_array($forumusers))
		{
			$userid = $loggedin['userid'];
			if (!$userid)
			{	// Guest
				$show['dbtech_downloads_activeusers']['numberguest']++;
			}
			else if (empty($userinfos["$userid"]) OR ($userinfos["$userid"]['lastactivity'] < $loggedin['lastactivity']))
			{
				$userinfos["$userid"] = $loggedin;
			}
		}

		// We are a guest and somehow got missed by the query.
		if (!$vbulletin->userinfo['userid'] AND !$show['dbtech_downloads_activeusers']['numberguest'])
		{
			$show['dbtech_downloads_activeusers']['numberguest']++;
		}

		$show['dbtech_downloads_activeusers']['activeusers'] = array();
		foreach ($userinfos AS $userid => $loggedin)
		{
			$show['dbtech_downloads_activeusers']['numberregistered']++;

			fetch_musername($loggedin);
			$loggedin['comma'] = $vbphrase['comma_space'];

			if (fetch_online_status($loggedin))
			{
				$show['dbtech_downloads_activeusers']['numbervisible']++;
				$show['dbtech_downloads_activeusers']['activeusers'][$show['dbtech_downloads_activeusers']['numbervisible']] = $loggedin;
			}
		}

		// Last element
		if ($show['dbtech_downloads_activeusers']['numbervisible'])
		{
			$show['dbtech_downloads_activeusers']['activeusers'][$show['dbtech_downloads_activeusers']['numbervisible']]['comma'] = '';
		}

		// memory saving
		unset($userinfos, $loggedin);

		$db->free_result($forumusers);

		if (intval($vbulletin->versionnumber) == 3)
		{
			// Oh vB3...
			$activeusers = $show['dbtech_downloads_activeusers']['activeusers'];
			$show['dbtech_downloads_activeusers']['activeusers'] = '';
			foreach ($activeusers as $loggedin)
			{
				// Manually do this template because it won't need to be customised anyway
				$show['dbtech_downloads_activeusers']['activeusers'] .= ($show['dbtech_downloads_activeusers']['activeusers'] != '' ? ', ' : '') . $stylevar['dirmark'] . '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $loggedin['userid'] . '">' . $loggedin['musername'] . '</a>' . $loggedin['invisiblemark'] . $loggedin['buddymark'];
			}
		}

		$show['dbtech_downloads_activeusers']['totalonline'] = $show['dbtech_downloads_activeusers']['numberregistered'] + $show['dbtech_downloads_activeusers']['numberguest'];
	}
	/*DBTECH_PRO_END*/
}

?>